package ui.editor;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface Item extends Element {
    ElementType TYPE = new ElementType(Item.class);

    // *** Ids ***

    @Type(base = Id.class)
    @Label(standard = "Ids")
    @XmlListBinding(mappings = @XmlListBinding.Mapping(element = "ids", type = Id.class))
    ListProperty PROP_IDS = new ListProperty(TYPE, "Ids");

    ElementList<Id> getIds();

}
