package ui.editor;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Whitespace;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

import ui.editor.service.IDValidationService;

@Image(path = "icons/transparent.gif")
public interface Id extends Element {
    ElementType TYPE = new ElementType(Id.class);

    // *** Id (ATTRIBUTE) ***

    @XmlBinding(path = "@id")
    @Label(standard = "Id")
    @Whitespace(trim = true)
    @Required
    @DependsOn({ "/Items/Ids/Id" })
    @Service(impl = IDValidationService.class)
    ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");

    Value<String> getId();

    void setId(String value);
}