package org.modelrefactoring.incquery.test;

import static org.junit.Assert.*;

import java.io.File;
import java.util.Collection;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.junit.BeforeClass;
import org.junit.Test;

public class IncQueryHeadlessTest {

	private static Resource javaResource;
	private static Pattern pattern;

	@BeforeClass
	public static void setUp(){
		initJavaResource();
		initPattern();
	}

	private static void initPattern() {
		File file = new File("src/org/modelrefactoring/incquery/test/query/dataTransmissionWithoutCompression.eiq");
		assertTrue("File must exist", file != null && file.exists());
		ResourceSet rs = new ResourceSetImpl();
		Resource resource = rs.getResource(URI.createFileURI(file.getAbsolutePath()), true);
		assertNotNull("Pattern resource " + file.getAbsolutePath() + " couldn't be loaded", javaResource);
		EObject model = resource.getContents().get(0);
		assertTrue("Pattern resource " + file.getAbsolutePath() + " must contain a Pattern", model instanceof PatternModel);
		PatternModel patternModel = (PatternModel) model;
		pattern = patternModel.getPatterns().get(0);
	}

	private static void initJavaResource() {
		File file = new File("src/org/modelrefactoring/incquery/test/model/DataTransmissionWithoutCompression.java");
		assertTrue("File must exist", file != null && file.exists());
		ResourceSet rs = new ResourceSetImpl();
		javaResource = rs.getResource(URI.createFileURI(file.getAbsolutePath()), true);
		assertNotNull("Java resource " + file.getAbsolutePath() + " couldn't be loaded", javaResource);
	}

	@Test
	public void testFindMatchesHeadless(){
		System.out.println("-------------------");
		System.out.println("file: " + javaResource.getURI().toString());
		IQuerySpecification<?> querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification(pattern);
		if(querySpecification != null){
			try {
				IncQueryEngine engine = IncQueryEngine.on(javaResource.getResourceSet());
				IncQueryMatcher<? extends IPatternMatch> matcher = querySpecification.getMatcher(engine);
				Collection<? extends IPatternMatch> matches = matcher.getAllMatches();
				for (IPatternMatch match : matches) {
					System.out.println(match);
				}
			} catch (IncQueryException e) {
				e.printStackTrace();
			}
		}					
	}

}