package MainApp.processors;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CopyPerspectiveSnippetProcessor {
	private static final String PERSPECTIVE_TEMPLATE_TAG="PerspectiveTemplate";
	private static final String MAIN_PERSPECTIVE_STACK_ID="MainPerspectiveStack";

	@Execute
	public void execute(EModelService modelService, MApplication application){
		MPerspectiveStack perspectiveStack=(MPerspectiveStack) modelService.find(MAIN_PERSPECTIVE_STACK_ID, application);
		MPerspective perspectiveClone;
		
		//clone each snippet that is a perspective and add the cloned perspective into the main PerspectiveStack
		for(MUIElement snippet:application.getSnippets()){
			if(snippet instanceof MPerspective && snippet.getTags().contains(PERSPECTIVE_TEMPLATE_TAG)){
				perspectiveClone=(MPerspective) modelService.cloneSnippet(application, snippet.getElementId(), null);
				perspectiveStack.getChildren().add(perspectiveClone);
			}
		}
	}
}
