package org.xtext.example.mydsl6.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.mydsl6.myDsl6.Collection;
import org.xtext.example.mydsl6.myDsl6.Context;
import org.xtext.example.mydsl6.myDsl6.Function;
import org.xtext.example.mydsl6.myDsl6.LookUp;
import org.xtext.example.mydsl6.myDsl6.Method;
import org.xtext.example.mydsl6.myDsl6.MyDsl6Package;
import org.xtext.example.mydsl6.myDsl6.TextField;
import org.xtext.example.mydsl6.myDsl6.Type;
import org.xtext.example.mydsl6.myDsl6.WebApplication;
import org.xtext.example.mydsl6.services.MyDsl6GrammarAccess;

@SuppressWarnings("all")
public class MyDsl6SemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private MyDsl6GrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == MyDsl6Package.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case MyDsl6Package.COLLECTION:
				if(context == grammarAccess.getCollectionRule() ||
				   context == grammarAccess.getContextUnitRule()) {
					sequence_Collection(context, (Collection) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.CONTEXT:
				if(context == grammarAccess.getContextRule() ||
				   context == grammarAccess.getContextUnitRule()) {
					sequence_Context(context, (Context) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.FUNCTION:
				if(context == grammarAccess.getContextUnitRule() ||
				   context == grammarAccess.getFunctionRule()) {
					sequence_Function(context, (Function) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.LOOK_UP:
				if(context == grammarAccess.getContextUnitRule() ||
				   context == grammarAccess.getFieldRule() ||
				   context == grammarAccess.getLookUpRule()) {
					sequence_LookUp(context, (LookUp) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.METHOD:
				if(context == grammarAccess.getContextUnitRule() ||
				   context == grammarAccess.getMethodRule()) {
					sequence_Method(context, (Method) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.TEXT_FIELD:
				if(context == grammarAccess.getContextUnitRule() ||
				   context == grammarAccess.getFieldRule() ||
				   context == grammarAccess.getTextFieldRule()) {
					sequence_TextField(context, (TextField) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.TYPE:
				if(context == grammarAccess.getContextUnitRule() ||
				   context == grammarAccess.getTypeRule()) {
					sequence_Type(context, (Type) semanticObject); 
					return; 
				}
				else break;
			case MyDsl6Package.WEB_APPLICATION:
				if(context == grammarAccess.getApplicationRule() ||
				   context == grammarAccess.getContextUnitRule()) {
					sequence_Application(context, (WebApplication) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=QualifiedName collection+=Collection collection+=Collection*)
	 */
	protected void sequence_Application(EObject context, WebApplication semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName ownmethod=Method)
	 */
	protected void sequence_Collection(EObject context, Collection semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.COLLECTION__OWNMETHOD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.COLLECTION__OWNMETHOD));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getCollectionAccess().getNameQualifiedNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getCollectionAccess().getOwnmethodMethodParserRuleCall_3_0(), semanticObject.getOwnmethod());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName app=Application)
	 */
	protected void sequence_Context(EObject context, Context semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.CONTEXT__APP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.CONTEXT__APP));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getContextAccess().getNameQualifiedNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getContextAccess().getAppApplicationParserRuleCall_3_0(), semanticObject.getApp());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName (type+=Type type+=Type*)?)
	 */
	protected void sequence_Function(EObject context, Function semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName type=[Type|QualifiedName] showField=[Field|QualifiedName])
	 */
	protected void sequence_LookUp(EObject context, LookUp semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.LOOK_UP__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.LOOK_UP__TYPE));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.LOOK_UP__SHOW_FIELD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.LOOK_UP__SHOW_FIELD));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLookUpAccess().getNameQualifiedNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getLookUpAccess().getTypeTypeQualifiedNameParserRuleCall_3_2_0_1(), semanticObject.getType());
		feeder.accept(grammarAccess.getLookUpAccess().getShowFieldFieldQualifiedNameParserRuleCall_4_2_0_1(), semanticObject.getShowField());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName (list+=Function list+=Function*)? (ownmethod+=Method ownmethod+=Method*)?)
	 */
	protected void sequence_Method(EObject context, Method semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName displayName=STRING property=STRING)
	 */
	protected void sequence_TextField(EObject context, TextField semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.CONTENTEXT_UNIT__NAME));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.TEXT_FIELD__DISPLAY_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.TEXT_FIELD__DISPLAY_NAME));
			if(transientValues.isValueTransient(semanticObject, MyDsl6Package.Literals.TEXT_FIELD__PROPERTY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl6Package.Literals.TEXT_FIELD__PROPERTY));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getTextFieldAccess().getNameQualifiedNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getTextFieldAccess().getDisplayNameSTRINGTerminalRuleCall_5_0(), semanticObject.getDisplayName());
		feeder.accept(grammarAccess.getTextFieldAccess().getPropertySTRINGTerminalRuleCall_8_0(), semanticObject.getProperty());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName parentType=[Type|QualifiedName]? (ownedField+=Field ownedField+=Field*)?)
	 */
	protected void sequence_Type(EObject context, Type semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
