/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package joinpoint;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see joinpoint.JoinpointFactory
 * @model kind="package"
 * @generated
 */
public interface JoinpointPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "joinpoint";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://joinpoint/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "joinpoint";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	JoinpointPackage eINSTANCE = joinpoint.impl.JoinpointPackageImpl.init();

	/**
	 * The meta object id for the '{@link joinpoint.impl.PairImpl <em>Pair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see joinpoint.impl.PairImpl
	 * @see joinpoint.impl.JoinpointPackageImpl#getPair()
	 * @generated
	 */
	int PAIR = 0;

	/**
	 * The feature id for the '<em><b>Pc</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIR__PC = 0;

	/**
	 * The feature id for the '<em><b>Base</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIR__BASE = 1;

	/**
	 * The number of structural features of the '<em>Pair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIR_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link joinpoint.impl.JoinPointImpl <em>Join Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see joinpoint.impl.JoinPointImpl
	 * @see joinpoint.impl.JoinpointPackageImpl#getJoinPoint()
	 * @generated
	 */
	int JOIN_POINT = 1;

	/**
	 * The feature id for the '<em><b>Has Matches</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_POINT__HAS_MATCHES = 0;

	/**
	 * The number of structural features of the '<em>Join Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_POINT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link joinpoint.impl.MatchImpl <em>Match</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see joinpoint.impl.MatchImpl
	 * @see joinpoint.impl.JoinpointPackageImpl#getMatch()
	 * @generated
	 */
	int MATCH = 2;

	/**
	 * The feature id for the '<em><b>Has Pairs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATCH__HAS_PAIRS = 0;

	/**
	 * The number of structural features of the '<em>Match</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATCH_FEATURE_COUNT = 1;


	/**
	 * Returns the meta object for class '{@link joinpoint.Pair <em>Pair</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pair</em>'.
	 * @see joinpoint.Pair
	 * @generated
	 */
	EClass getPair();

	/**
	 * Returns the meta object for the reference '{@link joinpoint.Pair#getPc <em>Pc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Pc</em>'.
	 * @see joinpoint.Pair#getPc()
	 * @see #getPair()
	 * @generated
	 */
	EReference getPair_Pc();

	/**
	 * Returns the meta object for the reference '{@link joinpoint.Pair#getBase <em>Base</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base</em>'.
	 * @see joinpoint.Pair#getBase()
	 * @see #getPair()
	 * @generated
	 */
	EReference getPair_Base();

	/**
	 * Returns the meta object for class '{@link joinpoint.JoinPoint <em>Join Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join Point</em>'.
	 * @see joinpoint.JoinPoint
	 * @generated
	 */
	EClass getJoinPoint();

	/**
	 * Returns the meta object for the containment reference list '{@link joinpoint.JoinPoint#getHasMatches <em>Has Matches</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has Matches</em>'.
	 * @see joinpoint.JoinPoint#getHasMatches()
	 * @see #getJoinPoint()
	 * @generated
	 */
	EReference getJoinPoint_HasMatches();

	/**
	 * Returns the meta object for class '{@link joinpoint.Match <em>Match</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Match</em>'.
	 * @see joinpoint.Match
	 * @generated
	 */
	EClass getMatch();

	/**
	 * Returns the meta object for the containment reference list '{@link joinpoint.Match#getHasPairs <em>Has Pairs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has Pairs</em>'.
	 * @see joinpoint.Match#getHasPairs()
	 * @see #getMatch()
	 * @generated
	 */
	EReference getMatch_HasPairs();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	JoinpointFactory getJoinpointFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link joinpoint.impl.PairImpl <em>Pair</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see joinpoint.impl.PairImpl
		 * @see joinpoint.impl.JoinpointPackageImpl#getPair()
		 * @generated
		 */
		EClass PAIR = eINSTANCE.getPair();

		/**
		 * The meta object literal for the '<em><b>Pc</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PAIR__PC = eINSTANCE.getPair_Pc();

		/**
		 * The meta object literal for the '<em><b>Base</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PAIR__BASE = eINSTANCE.getPair_Base();

		/**
		 * The meta object literal for the '{@link joinpoint.impl.JoinPointImpl <em>Join Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see joinpoint.impl.JoinPointImpl
		 * @see joinpoint.impl.JoinpointPackageImpl#getJoinPoint()
		 * @generated
		 */
		EClass JOIN_POINT = eINSTANCE.getJoinPoint();

		/**
		 * The meta object literal for the '<em><b>Has Matches</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JOIN_POINT__HAS_MATCHES = eINSTANCE.getJoinPoint_HasMatches();

		/**
		 * The meta object literal for the '{@link joinpoint.impl.MatchImpl <em>Match</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see joinpoint.impl.MatchImpl
		 * @see joinpoint.impl.JoinpointPackageImpl#getMatch()
		 * @generated
		 */
		EClass MATCH = eINSTANCE.getMatch();

		/**
		 * The meta object literal for the '<em><b>Has Pairs</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MATCH__HAS_PAIRS = eINSTANCE.getMatch_HasPairs();

	}

} //JoinpointPackage
