/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package aspectModel.util;

import aspectModel.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see aspectModel.AspectModelPackage
 * @generated
 */
public class AspectModelSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static AspectModelPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AspectModelSwitch() {
		if (modelPackage == null) {
			modelPackage = AspectModelPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case AspectModelPackage.ASPECT: {
				Aspect aspect = (Aspect)theEObject;
				T result = caseAspect(aspect);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ADVICE: {
				Advice advice = (Advice)theEObject;
				T result = caseAdvice(advice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.POINT_CUT: {
				PointCut pointCut = (PointCut)theEObject;
				T result = casePointCut(pointCut);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ABS_ELEM: {
				AbsElem absElem = (AbsElem)theEObject;
				T result = caseAbsElem(absElem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.PROPERTIE: {
				Propertie propertie = (Propertie)theEObject;
				T result = casePropertie(propertie);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ABS_ADV_ELEM: {
				AbsAdvElem absAdvElem = (AbsAdvElem)theEObject;
				T result = caseAbsAdvElem(absAdvElem);
				if (result == null) result = caseAbsElem(absAdvElem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ABS_PC_ELEM: {
				AbsPCElem absPCElem = (AbsPCElem)theEObject;
				T result = caseAbsPCElem(absPCElem);
				if (result == null) result = caseAbsElem(absPCElem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.PC_NODE: {
				PCNode pcNode = (PCNode)theEObject;
				T result = casePCNode(pcNode);
				if (result == null) result = caseAbsPCElem(pcNode);
				if (result == null) result = caseAbsElem(pcNode);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.PC_REFERENCE: {
				PCReference pcReference = (PCReference)theEObject;
				T result = casePCReference(pcReference);
				if (result == null) result = caseAbsPCElem(pcReference);
				if (result == null) result = caseAbsElem(pcReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ADV_NODE: {
				AdvNode advNode = (AdvNode)theEObject;
				T result = caseAdvNode(advNode);
				if (result == null) result = caseAbsAdvElem(advNode);
				if (result == null) result = caseAbsElem(advNode);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case AspectModelPackage.ADV_REFERENCE: {
				AdvReference advReference = (AdvReference)theEObject;
				T result = caseAdvReference(advReference);
				if (result == null) result = caseAbsAdvElem(advReference);
				if (result == null) result = caseAbsElem(advReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Aspect</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Aspect</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAspect(Aspect object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Advice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Advice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAdvice(Advice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Point Cut</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Point Cut</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePointCut(PointCut object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abs Elem</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abs Elem</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbsElem(AbsElem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Propertie</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Propertie</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertie(Propertie object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abs Adv Elem</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abs Adv Elem</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbsAdvElem(AbsAdvElem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abs PC Elem</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abs PC Elem</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbsPCElem(AbsPCElem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PC Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PC Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePCNode(PCNode object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PC Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PC Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePCReference(PCReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Adv Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Adv Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAdvNode(AdvNode object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Adv Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Adv Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAdvReference(AdvReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //AspectModelSwitch
