/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package aspectModel.util;

import aspectModel.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see aspectModel.AspectModelPackage
 * @generated
 */
public class AspectModelAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static AspectModelPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AspectModelAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = AspectModelPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AspectModelSwitch<Adapter> modelSwitch =
		new AspectModelSwitch<Adapter>() {
			@Override
			public Adapter caseAspect(Aspect object) {
				return createAspectAdapter();
			}
			@Override
			public Adapter caseAdvice(Advice object) {
				return createAdviceAdapter();
			}
			@Override
			public Adapter casePointCut(PointCut object) {
				return createPointCutAdapter();
			}
			@Override
			public Adapter caseAbsElem(AbsElem object) {
				return createAbsElemAdapter();
			}
			@Override
			public Adapter casePropertie(Propertie object) {
				return createPropertieAdapter();
			}
			@Override
			public Adapter caseAbsAdvElem(AbsAdvElem object) {
				return createAbsAdvElemAdapter();
			}
			@Override
			public Adapter caseAbsPCElem(AbsPCElem object) {
				return createAbsPCElemAdapter();
			}
			@Override
			public Adapter casePCNode(PCNode object) {
				return createPCNodeAdapter();
			}
			@Override
			public Adapter casePCReference(PCReference object) {
				return createPCReferenceAdapter();
			}
			@Override
			public Adapter caseAdvNode(AdvNode object) {
				return createAdvNodeAdapter();
			}
			@Override
			public Adapter caseAdvReference(AdvReference object) {
				return createAdvReferenceAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.Aspect <em>Aspect</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.Aspect
	 * @generated
	 */
	public Adapter createAspectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.Advice <em>Advice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.Advice
	 * @generated
	 */
	public Adapter createAdviceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.PointCut <em>Point Cut</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.PointCut
	 * @generated
	 */
	public Adapter createPointCutAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.AbsElem <em>Abs Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.AbsElem
	 * @generated
	 */
	public Adapter createAbsElemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.Propertie <em>Propertie</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.Propertie
	 * @generated
	 */
	public Adapter createPropertieAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.AbsAdvElem <em>Abs Adv Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.AbsAdvElem
	 * @generated
	 */
	public Adapter createAbsAdvElemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.AbsPCElem <em>Abs PC Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.AbsPCElem
	 * @generated
	 */
	public Adapter createAbsPCElemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.PCNode <em>PC Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.PCNode
	 * @generated
	 */
	public Adapter createPCNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.PCReference <em>PC Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.PCReference
	 * @generated
	 */
	public Adapter createPCReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.AdvNode <em>Adv Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.AdvNode
	 * @generated
	 */
	public Adapter createAdvNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link aspectModel.AdvReference <em>Adv Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see aspectModel.AdvReference
	 * @generated
	 */
	public Adapter createAdvReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //AspectModelAdapterFactory
