/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package aspectModel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see aspectModel.AspectModelFactory
 * @model kind="package"
 * @generated
 */
public interface AspectModelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "aspectModel";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://aspectModel";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "aspectModel";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AspectModelPackage eINSTANCE = aspectModel.impl.AspectModelPackageImpl.init();

	/**
	 * The meta object id for the '{@link aspectModel.impl.AspectImpl <em>Aspect</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AspectImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAspect()
	 * @generated
	 */
	int ASPECT = 0;

	/**
	 * The feature id for the '<em><b>Has Advice</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASPECT__HAS_ADVICE = 0;

	/**
	 * The feature id for the '<em><b>Has Point Cut</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASPECT__HAS_POINT_CUT = 1;

	/**
	 * The number of structural features of the '<em>Aspect</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASPECT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AdviceImpl <em>Advice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AdviceImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAdvice()
	 * @generated
	 */
	int ADVICE = 1;

	/**
	 * The feature id for the '<em><b>Has Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADVICE__HAS_ELEMENTS = 0;

	/**
	 * The number of structural features of the '<em>Advice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADVICE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link aspectModel.impl.PointCutImpl <em>Point Cut</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.PointCutImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getPointCut()
	 * @generated
	 */
	int POINT_CUT = 2;

	/**
	 * The feature id for the '<em><b>Has Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_CUT__HAS_ELEMENTS = 0;

	/**
	 * The number of structural features of the '<em>Point Cut</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_CUT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AbsElemImpl <em>Abs Elem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AbsElemImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAbsElem()
	 * @generated
	 */
	int ABS_ELEM = 3;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ELEM__HAS_PROPERTIES = 0;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ELEM__ADS_ID = 1;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ELEM__ELEM_TYPE = 2;

	/**
	 * The number of structural features of the '<em>Abs Elem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ELEM_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link aspectModel.impl.PropertieImpl <em>Propertie</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.PropertieImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getPropertie()
	 * @generated
	 */
	int PROPERTIE = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTIE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTIE__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Propertie</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTIE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AbsAdvElemImpl <em>Abs Adv Elem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AbsAdvElemImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAbsAdvElem()
	 * @generated
	 */
	int ABS_ADV_ELEM = 5;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM__HAS_PROPERTIES = ABS_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM__ADS_ID = ABS_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM__ELEM_TYPE = ABS_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM__CONDITIONS = ABS_ELEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From Point Cut</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM__FROM_POINT_CUT = ABS_ELEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abs Adv Elem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_ADV_ELEM_FEATURE_COUNT = ABS_ELEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AbsPCElemImpl <em>Abs PC Elem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AbsPCElemImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAbsPCElem()
	 * @generated
	 */
	int ABS_PC_ELEM = 6;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM__HAS_PROPERTIES = ABS_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM__ADS_ID = ABS_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM__ELEM_TYPE = ABS_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM__CONDITIONS = ABS_ELEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>To Advice</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM__TO_ADVICE = ABS_ELEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abs PC Elem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABS_PC_ELEM_FEATURE_COUNT = ABS_ELEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link aspectModel.impl.PCNodeImpl <em>PC Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.PCNodeImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getPCNode()
	 * @generated
	 */
	int PC_NODE = 7;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__HAS_PROPERTIES = ABS_PC_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__ADS_ID = ABS_PC_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__ELEM_TYPE = ABS_PC_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__CONDITIONS = ABS_PC_ELEM__CONDITIONS;

	/**
	 * The feature id for the '<em><b>To Advice</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__TO_ADVICE = ABS_PC_ELEM__TO_ADVICE;

	/**
	 * The feature id for the '<em><b>Has References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE__HAS_REFERENCES = ABS_PC_ELEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>PC Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_NODE_FEATURE_COUNT = ABS_PC_ELEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link aspectModel.impl.PCReferenceImpl <em>PC Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.PCReferenceImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getPCReference()
	 * @generated
	 */
	int PC_REFERENCE = 8;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__HAS_PROPERTIES = ABS_PC_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__ADS_ID = ABS_PC_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__ELEM_TYPE = ABS_PC_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__CONDITIONS = ABS_PC_ELEM__CONDITIONS;

	/**
	 * The feature id for the '<em><b>To Advice</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__TO_ADVICE = ABS_PC_ELEM__TO_ADVICE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__SOURCE = ABS_PC_ELEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE__TARGET = ABS_PC_ELEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>PC Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PC_REFERENCE_FEATURE_COUNT = ABS_PC_ELEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AdvNodeImpl <em>Adv Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AdvNodeImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAdvNode()
	 * @generated
	 */
	int ADV_NODE = 9;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__HAS_PROPERTIES = ABS_ADV_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__ADS_ID = ABS_ADV_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__ELEM_TYPE = ABS_ADV_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__CONDITIONS = ABS_ADV_ELEM__CONDITIONS;

	/**
	 * The feature id for the '<em><b>From Point Cut</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__FROM_POINT_CUT = ABS_ADV_ELEM__FROM_POINT_CUT;

	/**
	 * The feature id for the '<em><b>Has References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE__HAS_REFERENCES = ABS_ADV_ELEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Adv Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_NODE_FEATURE_COUNT = ABS_ADV_ELEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link aspectModel.impl.AdvReferenceImpl <em>Adv Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.impl.AdvReferenceImpl
	 * @see aspectModel.impl.AspectModelPackageImpl#getAdvReference()
	 * @generated
	 */
	int ADV_REFERENCE = 10;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__HAS_PROPERTIES = ABS_ADV_ELEM__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ads ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__ADS_ID = ABS_ADV_ELEM__ADS_ID;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__ELEM_TYPE = ABS_ADV_ELEM__ELEM_TYPE;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__CONDITIONS = ABS_ADV_ELEM__CONDITIONS;

	/**
	 * The feature id for the '<em><b>From Point Cut</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__FROM_POINT_CUT = ABS_ADV_ELEM__FROM_POINT_CUT;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__SOURCE = ABS_ADV_ELEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE__TARGET = ABS_ADV_ELEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Adv Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADV_REFERENCE_FEATURE_COUNT = ABS_ADV_ELEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link aspectModel.PointCutApplicationConditions <em>Point Cut Application Conditions</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.PointCutApplicationConditions
	 * @see aspectModel.impl.AspectModelPackageImpl#getPointCutApplicationConditions()
	 * @generated
	 */
	int POINT_CUT_APPLICATION_CONDITIONS = 11;

	/**
	 * The meta object id for the '{@link aspectModel.AdviceApplicationConditions <em>Advice Application Conditions</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see aspectModel.AdviceApplicationConditions
	 * @see aspectModel.impl.AspectModelPackageImpl#getAdviceApplicationConditions()
	 * @generated
	 */
	int ADVICE_APPLICATION_CONDITIONS = 12;


	/**
	 * Returns the meta object for class '{@link aspectModel.Aspect <em>Aspect</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Aspect</em>'.
	 * @see aspectModel.Aspect
	 * @generated
	 */
	EClass getAspect();

	/**
	 * Returns the meta object for the containment reference '{@link aspectModel.Aspect#getHasAdvice <em>Has Advice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Has Advice</em>'.
	 * @see aspectModel.Aspect#getHasAdvice()
	 * @see #getAspect()
	 * @generated
	 */
	EReference getAspect_HasAdvice();

	/**
	 * Returns the meta object for the containment reference '{@link aspectModel.Aspect#getHasPointCut <em>Has Point Cut</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Has Point Cut</em>'.
	 * @see aspectModel.Aspect#getHasPointCut()
	 * @see #getAspect()
	 * @generated
	 */
	EReference getAspect_HasPointCut();

	/**
	 * Returns the meta object for class '{@link aspectModel.Advice <em>Advice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Advice</em>'.
	 * @see aspectModel.Advice
	 * @generated
	 */
	EClass getAdvice();

	/**
	 * Returns the meta object for the containment reference list '{@link aspectModel.Advice#getHasElements <em>Has Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has Elements</em>'.
	 * @see aspectModel.Advice#getHasElements()
	 * @see #getAdvice()
	 * @generated
	 */
	EReference getAdvice_HasElements();

	/**
	 * Returns the meta object for class '{@link aspectModel.PointCut <em>Point Cut</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Point Cut</em>'.
	 * @see aspectModel.PointCut
	 * @generated
	 */
	EClass getPointCut();

	/**
	 * Returns the meta object for the containment reference list '{@link aspectModel.PointCut#getHasElements <em>Has Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has Elements</em>'.
	 * @see aspectModel.PointCut#getHasElements()
	 * @see #getPointCut()
	 * @generated
	 */
	EReference getPointCut_HasElements();

	/**
	 * Returns the meta object for class '{@link aspectModel.AbsElem <em>Abs Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abs Elem</em>'.
	 * @see aspectModel.AbsElem
	 * @generated
	 */
	EClass getAbsElem();

	/**
	 * Returns the meta object for the containment reference list '{@link aspectModel.AbsElem#getHasProperties <em>Has Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has Properties</em>'.
	 * @see aspectModel.AbsElem#getHasProperties()
	 * @see #getAbsElem()
	 * @generated
	 */
	EReference getAbsElem_HasProperties();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.AbsElem#getAdsID <em>Ads ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ads ID</em>'.
	 * @see aspectModel.AbsElem#getAdsID()
	 * @see #getAbsElem()
	 * @generated
	 */
	EAttribute getAbsElem_AdsID();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.AbsElem#getElemType <em>Elem Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Elem Type</em>'.
	 * @see aspectModel.AbsElem#getElemType()
	 * @see #getAbsElem()
	 * @generated
	 */
	EAttribute getAbsElem_ElemType();

	/**
	 * Returns the meta object for class '{@link aspectModel.Propertie <em>Propertie</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Propertie</em>'.
	 * @see aspectModel.Propertie
	 * @generated
	 */
	EClass getPropertie();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.Propertie#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see aspectModel.Propertie#getName()
	 * @see #getPropertie()
	 * @generated
	 */
	EAttribute getPropertie_Name();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.Propertie#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see aspectModel.Propertie#getValue()
	 * @see #getPropertie()
	 * @generated
	 */
	EAttribute getPropertie_Value();

	/**
	 * Returns the meta object for class '{@link aspectModel.AbsAdvElem <em>Abs Adv Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abs Adv Elem</em>'.
	 * @see aspectModel.AbsAdvElem
	 * @generated
	 */
	EClass getAbsAdvElem();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.AbsAdvElem#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Conditions</em>'.
	 * @see aspectModel.AbsAdvElem#getConditions()
	 * @see #getAbsAdvElem()
	 * @generated
	 */
	EAttribute getAbsAdvElem_Conditions();

	/**
	 * Returns the meta object for the reference '{@link aspectModel.AbsAdvElem#getFromPointCut <em>From Point Cut</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From Point Cut</em>'.
	 * @see aspectModel.AbsAdvElem#getFromPointCut()
	 * @see #getAbsAdvElem()
	 * @generated
	 */
	EReference getAbsAdvElem_FromPointCut();

	/**
	 * Returns the meta object for class '{@link aspectModel.AbsPCElem <em>Abs PC Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abs PC Elem</em>'.
	 * @see aspectModel.AbsPCElem
	 * @generated
	 */
	EClass getAbsPCElem();

	/**
	 * Returns the meta object for the attribute '{@link aspectModel.AbsPCElem#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Conditions</em>'.
	 * @see aspectModel.AbsPCElem#getConditions()
	 * @see #getAbsPCElem()
	 * @generated
	 */
	EAttribute getAbsPCElem_Conditions();

	/**
	 * Returns the meta object for the reference list '{@link aspectModel.AbsPCElem#getToAdvice <em>To Advice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>To Advice</em>'.
	 * @see aspectModel.AbsPCElem#getToAdvice()
	 * @see #getAbsPCElem()
	 * @generated
	 */
	EReference getAbsPCElem_ToAdvice();

	/**
	 * Returns the meta object for class '{@link aspectModel.PCNode <em>PC Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PC Node</em>'.
	 * @see aspectModel.PCNode
	 * @generated
	 */
	EClass getPCNode();

	/**
	 * Returns the meta object for the reference list '{@link aspectModel.PCNode#getHasReferences <em>Has References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Has References</em>'.
	 * @see aspectModel.PCNode#getHasReferences()
	 * @see #getPCNode()
	 * @generated
	 */
	EReference getPCNode_HasReferences();

	/**
	 * Returns the meta object for class '{@link aspectModel.PCReference <em>PC Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PC Reference</em>'.
	 * @see aspectModel.PCReference
	 * @generated
	 */
	EClass getPCReference();

	/**
	 * Returns the meta object for the reference '{@link aspectModel.PCReference#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see aspectModel.PCReference#getSource()
	 * @see #getPCReference()
	 * @generated
	 */
	EReference getPCReference_Source();

	/**
	 * Returns the meta object for the reference '{@link aspectModel.PCReference#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see aspectModel.PCReference#getTarget()
	 * @see #getPCReference()
	 * @generated
	 */
	EReference getPCReference_Target();

	/**
	 * Returns the meta object for class '{@link aspectModel.AdvNode <em>Adv Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Adv Node</em>'.
	 * @see aspectModel.AdvNode
	 * @generated
	 */
	EClass getAdvNode();

	/**
	 * Returns the meta object for the reference list '{@link aspectModel.AdvNode#getHasReferences <em>Has References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Has References</em>'.
	 * @see aspectModel.AdvNode#getHasReferences()
	 * @see #getAdvNode()
	 * @generated
	 */
	EReference getAdvNode_HasReferences();

	/**
	 * Returns the meta object for class '{@link aspectModel.AdvReference <em>Adv Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Adv Reference</em>'.
	 * @see aspectModel.AdvReference
	 * @generated
	 */
	EClass getAdvReference();

	/**
	 * Returns the meta object for the reference '{@link aspectModel.AdvReference#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see aspectModel.AdvReference#getSource()
	 * @see #getAdvReference()
	 * @generated
	 */
	EReference getAdvReference_Source();

	/**
	 * Returns the meta object for the reference '{@link aspectModel.AdvReference#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see aspectModel.AdvReference#getTarget()
	 * @see #getAdvReference()
	 * @generated
	 */
	EReference getAdvReference_Target();

	/**
	 * Returns the meta object for enum '{@link aspectModel.PointCutApplicationConditions <em>Point Cut Application Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Point Cut Application Conditions</em>'.
	 * @see aspectModel.PointCutApplicationConditions
	 * @generated
	 */
	EEnum getPointCutApplicationConditions();

	/**
	 * Returns the meta object for enum '{@link aspectModel.AdviceApplicationConditions <em>Advice Application Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Advice Application Conditions</em>'.
	 * @see aspectModel.AdviceApplicationConditions
	 * @generated
	 */
	EEnum getAdviceApplicationConditions();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	AspectModelFactory getAspectModelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link aspectModel.impl.AspectImpl <em>Aspect</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AspectImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAspect()
		 * @generated
		 */
		EClass ASPECT = eINSTANCE.getAspect();

		/**
		 * The meta object literal for the '<em><b>Has Advice</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASPECT__HAS_ADVICE = eINSTANCE.getAspect_HasAdvice();

		/**
		 * The meta object literal for the '<em><b>Has Point Cut</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASPECT__HAS_POINT_CUT = eINSTANCE.getAspect_HasPointCut();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AdviceImpl <em>Advice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AdviceImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAdvice()
		 * @generated
		 */
		EClass ADVICE = eINSTANCE.getAdvice();

		/**
		 * The meta object literal for the '<em><b>Has Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ADVICE__HAS_ELEMENTS = eINSTANCE.getAdvice_HasElements();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.PointCutImpl <em>Point Cut</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.PointCutImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getPointCut()
		 * @generated
		 */
		EClass POINT_CUT = eINSTANCE.getPointCut();

		/**
		 * The meta object literal for the '<em><b>Has Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POINT_CUT__HAS_ELEMENTS = eINSTANCE.getPointCut_HasElements();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AbsElemImpl <em>Abs Elem</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AbsElemImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAbsElem()
		 * @generated
		 */
		EClass ABS_ELEM = eINSTANCE.getAbsElem();

		/**
		 * The meta object literal for the '<em><b>Has Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABS_ELEM__HAS_PROPERTIES = eINSTANCE.getAbsElem_HasProperties();

		/**
		 * The meta object literal for the '<em><b>Ads ID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABS_ELEM__ADS_ID = eINSTANCE.getAbsElem_AdsID();

		/**
		 * The meta object literal for the '<em><b>Elem Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABS_ELEM__ELEM_TYPE = eINSTANCE.getAbsElem_ElemType();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.PropertieImpl <em>Propertie</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.PropertieImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getPropertie()
		 * @generated
		 */
		EClass PROPERTIE = eINSTANCE.getPropertie();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTIE__NAME = eINSTANCE.getPropertie_Name();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTIE__VALUE = eINSTANCE.getPropertie_Value();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AbsAdvElemImpl <em>Abs Adv Elem</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AbsAdvElemImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAbsAdvElem()
		 * @generated
		 */
		EClass ABS_ADV_ELEM = eINSTANCE.getAbsAdvElem();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABS_ADV_ELEM__CONDITIONS = eINSTANCE.getAbsAdvElem_Conditions();

		/**
		 * The meta object literal for the '<em><b>From Point Cut</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABS_ADV_ELEM__FROM_POINT_CUT = eINSTANCE.getAbsAdvElem_FromPointCut();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AbsPCElemImpl <em>Abs PC Elem</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AbsPCElemImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAbsPCElem()
		 * @generated
		 */
		EClass ABS_PC_ELEM = eINSTANCE.getAbsPCElem();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABS_PC_ELEM__CONDITIONS = eINSTANCE.getAbsPCElem_Conditions();

		/**
		 * The meta object literal for the '<em><b>To Advice</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABS_PC_ELEM__TO_ADVICE = eINSTANCE.getAbsPCElem_ToAdvice();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.PCNodeImpl <em>PC Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.PCNodeImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getPCNode()
		 * @generated
		 */
		EClass PC_NODE = eINSTANCE.getPCNode();

		/**
		 * The meta object literal for the '<em><b>Has References</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PC_NODE__HAS_REFERENCES = eINSTANCE.getPCNode_HasReferences();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.PCReferenceImpl <em>PC Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.PCReferenceImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getPCReference()
		 * @generated
		 */
		EClass PC_REFERENCE = eINSTANCE.getPCReference();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PC_REFERENCE__SOURCE = eINSTANCE.getPCReference_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PC_REFERENCE__TARGET = eINSTANCE.getPCReference_Target();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AdvNodeImpl <em>Adv Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AdvNodeImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAdvNode()
		 * @generated
		 */
		EClass ADV_NODE = eINSTANCE.getAdvNode();

		/**
		 * The meta object literal for the '<em><b>Has References</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ADV_NODE__HAS_REFERENCES = eINSTANCE.getAdvNode_HasReferences();

		/**
		 * The meta object literal for the '{@link aspectModel.impl.AdvReferenceImpl <em>Adv Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.impl.AdvReferenceImpl
		 * @see aspectModel.impl.AspectModelPackageImpl#getAdvReference()
		 * @generated
		 */
		EClass ADV_REFERENCE = eINSTANCE.getAdvReference();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ADV_REFERENCE__SOURCE = eINSTANCE.getAdvReference_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ADV_REFERENCE__TARGET = eINSTANCE.getAdvReference_Target();

		/**
		 * The meta object literal for the '{@link aspectModel.PointCutApplicationConditions <em>Point Cut Application Conditions</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.PointCutApplicationConditions
		 * @see aspectModel.impl.AspectModelPackageImpl#getPointCutApplicationConditions()
		 * @generated
		 */
		EEnum POINT_CUT_APPLICATION_CONDITIONS = eINSTANCE.getPointCutApplicationConditions();

		/**
		 * The meta object literal for the '{@link aspectModel.AdviceApplicationConditions <em>Advice Application Conditions</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see aspectModel.AdviceApplicationConditions
		 * @see aspectModel.impl.AspectModelPackageImpl#getAdviceApplicationConditions()
		 * @generated
		 */
		EEnum ADVICE_APPLICATION_CONDITIONS = eINSTANCE.getAdviceApplicationConditions();

	}

} //AspectModelPackage
