package org.eclipse.datatools.examples.podreader.views;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PreviewBirtAction implements IWorkbenchWindowActionDelegate {
	
	//static Logger logger = Logger.getLogger(PreviewBirtAction.class.getName());	
	
	private IWorkbenchWindow window;
	private String reportName;
	private Browser browser;
	/**
	 * The constructor.
	 */
	public PreviewBirtAction() {
	}

	public void setReportName(String report)
	{
		reportName = report;
	}
	public void setBrowser(Browser brw)
	{
		browser = brw;
	}	
	public void run(IAction action) {
		try {
			WebViewer.display(reportName , WebViewer.HTML, true);	
		} catch (Exception e) {
			//logger.error(e);
			e.printStackTrace();
		}

	}
	public void run() {
		try {
		
			//option 1 display with no parameters in SWT Browser uses the /run mapping (Parameter prompting will ocurr for parameters 
			//that have no default value and are required
			WebViewer.display(reportName, WebViewer.HTML, browser, "run");
			 		
			//option 2 display BIRT Viewer in sepearate Browser with parameter entry control
			//last variable determines which mapping is used true=/frameset false=/run
			//WebViewer.display(reportName , WebViewer.HTML, true);
			
				
			//option 3 display BIRT Viewer in SWT Browser.  Note parameters have to be entered usng the parameter control
			//WebViewer.startup(null);
			//String format = "html";
			//String finalURL = createURL( "frameset", reportName, format );
			//browser.setUrl( finalURL );		
			//RC3 added this and option 4 is not required any longer
			//WebViewer.display(reportName, WebViewer.HTML, browser, "frameset");			
			
			
			
			//option 4 display with parameters encoded in the URL - Note this required adding additional functions
			//WebViewer.startup(null);
			//String format = "html";
			//String preParameters = createURL( "run", reportName, format );
			//Make sure to encode your parameters
			//String parmNameString =  URLEncoder.encode( "Parm", "utf-8" );
			//String parmValueString =  URLEncoder.encode( "MyTest Parameter", "utf-8" );
			//String finalUrl = preParameters + "&" + parmNameString + "=" + parmValueString;
			//browser.setUrl( finalUrl );			
			

			
		} catch (Exception e) {
			e.printStackTrace();
		}

	

		
	}
	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
	private static String createURL( String servletName, String report, String format )
	{
		String encodedReportName = null;
		String encodedDocumentName = null;
		
		try
		{
			encodedReportName = URLEncoder.encode( report, "utf-8" ); //$NON-NLS-1$
		}
		catch ( UnsupportedEncodingException e )
		{
			// Do nothing
		}
		
		if ( encodedReportName != null && encodedReportName.length( ) > 0 )
		{
			encodedDocumentName = encodedReportName.substring( 0, encodedReportName.lastIndexOf( "." ) ) + ".rptdocument"; //$NON-NLS-1$
		}
		
		String locale = ViewerPlugin.getDefault( ).getPluginPreferences( ).getString( WebViewer.USER_LOCALE );
		
		String svgFlag = ViewerPlugin.getDefault( ).getPluginPreferences( ).getString( WebViewer.SVG_FLAG );
		boolean bSVGFlag = false;
		if ( "true".equalsIgnoreCase( svgFlag ) ) //$NON-NLS-1$
		{
			bSVGFlag = true;
		}

		String masterPageContent = ViewerPlugin.getDefault( ).getPluginPreferences( ).getString( WebViewer.MASTER_PAGE_CONTENT );
		boolean bMasterPageContent = true;
		if ( "false".equalsIgnoreCase( masterPageContent ) ) //$NON-NLS-1$
		{
			bMasterPageContent = false;
		}

		// So far, only report name is encoded as utf-8 format 
		return getBaseURL( )
			+ servletName + "?" //$NON-NLS-1$
			+ "__report=" + encodedReportName //$NON-NLS-1$
			+  ( "run".equalsIgnoreCase( servletName )? "" : "&__document=" + encodedDocumentName )  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			+ "&__format=" + format //$NON-NLS-1$
			+ "&__svg=" +  String.valueOf( bSVGFlag ) //$NON-NLS-1$
			+ ( WebViewer.LocaleTable.containsKey( locale )? "&__locale=" + WebViewer.LocaleTable.get( locale ) : "" ) //$NON-NLS-1$ //$NON-NLS-2$
			+ "&__designer=true" //$NON-NLS-1$
			+ "&__masterpage=" + String.valueOf( bMasterPageContent ); //$NON-NLS-1$
		
	}
	private static String getBaseURL( )
	{
		return "http://" + WebappAccessor.getHost( ) + ":" //$NON-NLS-1$ //$NON-NLS-2$
			+ WebappAccessor.getPort( )	+ "/viewer/"; //$NON-NLS-1$
	}
}