/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.views;

import java.util.Properties;


import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.examples.podreader.cp.PodProfileConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

//Added by JBW
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.layout.GridLayout;
//JBW

public class PodContentView extends ViewPart {

	//Added JBW
    private transient Text reportLocation = null;
    private transient Button browseFolderButton = null;
    private Composite lParent;
    private GridData gridData;
	public static final String BIRT_HOME   = "C:/birt-runtime-2_0_1/Report Engine";
	public static final String REPORT_FILE = "C:/test/testSampleDB.rptdesign";
	private Browser browser;
	private ProgressBar progressBar;	
	//JBW
	
	
	public static final String VIEW_ID = 
		"org.eclipse.datatools.examples.podreader.views.PodContentView";
	
	private TableViewer viewer;
	
	private static PodContentView view;
	
	public static PodContentView getPodView() {
		return view;
	}
	
	/**
	 * The constructor.
	 */
	public PodContentView() {
		view = this;
	}
	
	private void loadPodContent(String path) {
		if (viewer == null) {
			return;
		}
		viewer.setInput(path);
	}
	
	private void clearPodContent() {
		if (viewer == null) {
			return;
		}
		viewer.getTable().clearAll();
	}
	
	private Table createTable(Composite parent) {
		
		

		Table t = new Table(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 3;
		t.setLayoutData(gridData);
		
		t.setHeaderVisible(true);
		t.setLinesVisible(true);
		TableColumn tc = new TableColumn(t, SWT.LEFT, 0);
		tc.setText("Name");
		tc.setWidth(375);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 1);
		tc.setText("Artist");
		tc.setWidth(220);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ARTIST));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ARTIST));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 2);
		tc.setText("Album");
		tc.setWidth(200);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ALBUM));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ALBUM));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 3);
		tc.setText("Genre");
		tc.setWidth(75);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_GENRE));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_GENRE));
			}
		});
		return t;
	}
	
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
		
		//Added Tabs JBW
		TabFolder tabFolder = new TabFolder( parent, SWT.NONE);
		{	
			TabItem tabDTP = new TabItem( tabFolder, SWT.NONE);
			tabDTP.setText("DTP");
			{
				Composite comp = new Composite( tabFolder, SWT.NONE);
				comp.setLayout(new GridLayout());
				tabDTP.setControl(comp);
				
				viewer = new TableViewer(createTable(comp));
				viewer.setContentProvider(new ViewContentProvider());
				viewer.setLabelProvider(new ViewLabelProvider());
				viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
				addConnectionProfileHooks();
			}
			TabItem tabBIRT = new TabItem( tabFolder, SWT.NONE);
			tabBIRT.setText("BIRT");
			{
				Composite comp = new Composite( tabFolder, SWT.NONE);
				comp.setLayout(new GridLayout());
				tabBIRT.setControl(comp);
				createBirtControl(comp);
			}
		}
	}
	
	private void addConnectionProfileHooks() {
		ProfileManager manager = ProfileManager.getInstance();
		// Hook existing connection profiles
		addExistingProfileHooks(manager);
		// Hook new connection profiles
		addNewProfileHooks(manager);
	}
	
	private void addNewProfileHooks(ProfileManager manager) {
		manager.addProfileListener(new IProfileListener() {
			public void profileAdded(IConnectionProfile profile) {
				addConnectionListener(profile);
				
			}
			public void profileDeleted(IConnectionProfile arg0) {
				// don't care
				
			}
			public void profileChanged(IConnectionProfile arg0) {
				// don't care
			}
		});
	}

	private void addExistingProfileHooks(ProfileManager manager) {
		IConnectionProfile[] profiles = manager.getProfiles();
		for (int i = 0; i < profiles.length; i++) {
			addConnectionListener(profiles[i]);
		}
	}

	private void addConnectionListener(IConnectionProfile profile) {
		IManagedConnection conn = 
			profile.getManagedConnection(PodProfileConstants.POD_CONNECTION_FACTORY_ID);
		if (conn != null) {
			conn.addConnectionListener(new IManagedConnectionListener() {
				public void opened(final ConnectEvent ce) {
					PodContentView.getPodView().getSite().
						getShell().getDisplay().asyncExec(new Runnable() {
							public void run() {
								Properties props = 
									ce.getConnectionProfile().getBaseProperties();
								String path = (String)props.get("podPath");
								if (path != null) {
									loadPodContent(path);
								}
							}
						});
				}
				public void modified(ConnectEvent ce) {
					// Do nothing
				}
				public boolean okToClose(ConnectEvent ce) {
					// Always ok to close
					return true;
				}
				public void aboutToClose(ConnectEvent ce) {
					// Do nothing
				}
				public void closed(ConnectEvent ce) {
					PodContentView.getPodView().getSite().
						getShell().getDisplay().asyncExec(new Runnable() {
						public void run() {
							clearPodContent();
						}
					});
				}
			});
		}
	}
	//Added JBW
	   public void createBirtControl(Composite parent) {
	        // TODO Auto-generated method stub
	    	lParent = parent;
	        parent.setLayout(new GridLayout());
	        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
	        gridData = gd;           
	        Group reportGroup = new Group(parent,SWT.SHADOW_IN);
	        reportGroup.setText("Select report:");
	        GridLayout layout = new GridLayout(2, false);        
	        reportGroup.setLayout(layout);
	        gd = new GridData(GridData.FILL_HORIZONTAL);
	        reportGroup.setLayoutData(gd);
	        
	        gd = new GridData();
	        gd.horizontalSpan = 2;
	                
	        Label label = new Label(reportGroup, SWT.NONE);
	        label.setText("Full Path:");
	        
	        label.setLayoutData(gd);

	        reportLocation = new Text(reportGroup, SWT.BORDER);
	        gd = new GridData(GridData.FILL_HORIZONTAL);
	        reportLocation.setLayoutData(gd);
	        //setPageComplete(false);
	        reportLocation.addModifyListener(new ModifyListener(){

	            public void modifyText(ModifyEvent e)
	            {
	            	//
	            }
	            
	        });
	        
	        browseFolderButton = new Button(reportGroup, SWT.RIGHT);
	        browseFolderButton.setText("..."); //$NON-NLS-1$
	        browseFolderButton.addSelectionListener(new SelectionAdapter(){

	            /* (non-Javadoc)
	             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	             */
	            public void widgetSelected(SelectionEvent e)
	            {
	            	FileDialog dialog = new FileDialog(reportLocation.getShell());
	            	String [] extension = { "*.rptdesign"};
	            	dialog.setFilterExtensions(extension);
	                if(reportLocation.getText() != null && reportLocation.getText().trim().length() > 0)
	                {
	               	
	                    dialog.setFilterPath(reportLocation.getText());
	                   
	                }
	                
	                String selectedLocation = dialog.open();
	                if(selectedLocation != null)
	                {
	                	reportLocation.setText(selectedLocation);
	                }
	            }
	            
	        });
	                
	        Button showReport = new Button(reportGroup, SWT.PUSH);
	        showReport.setText("Run Report");
	         
	        showReport.addSelectionListener(new SelectionListener(){
	          
	            /* (non-Javadoc)
	             * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	             */
	            public void widgetSelected(SelectionEvent e) {
	            	previewReport();
	            	//addReportParameters(lParent, gridData);
	                //openReportRunner();
	            }
	            /* (non-Javadoc)
	             * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	             */
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // TODO Auto-generated method stub

	            }
	        });
	        
	    
			browser = new Browser( parent, SWT.NONE );
			gd = new GridData( GridData.FILL_BOTH );
			gd.horizontalSpan = 2;
			browser.setLayoutData( gd );
			browser.addLocationListener( new LocationAdapter( ) {

				public void changed( final LocationEvent e )
				{
					progressBar.setVisible( false );
				}

				public void changing( final LocationEvent e )
				{
					progressBar.setVisible( true );
				}
			} );

			gd = new GridData( GridData.END, GridData.CENTER, false, false );
			//gd = new GridData( GridData.FILL_BOTH );
			gd.heightHint = 10;
			gd.widthHint = 100;  
			progressBar = new ProgressBar( parent, SWT.INDETERMINATE );
			progressBar.setLayoutData( gd );
			progressBar.setVisible( false ); 
	        
	    }	
	    //Added JBW
	    private void previewReport(){

	    	String report = reportLocation.getText();
	 
	    	if (report.length() != 0) {
	    		
	    		//addReportParameters(this.lParent,new GridData( GridData.END, GridData.CENTER, false, false ));
	    		
	    		PreviewBirtAction preview = new PreviewBirtAction();
	    		preview.setReportName(report);
	    		preview.setBrowser(browser);
	    		preview.run();
	    		preview.dispose();
	    	}
	    }
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
}