/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.cp.ui.wizards;

import java.util.Properties;

import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.examples.podreader.cp.PodProfileConstants;
import org.eclipse.datatools.examples.podreader.cp.PodProfilePropertyConstants;

public class PodConnectionProfileNewWizard extends NewConnectionProfileWizard {

	private PodDrivePropertyWizardPage propPage;

	/**
	 * 
	 */
	public PodConnectionProfileNewWizard() {
		setWindowTitle("New Pod Reader Connection Profile");
		setNeedsProgressMonitor(true);
		mProviderID = PodProfileConstants.POD_PROFILE_ID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addCustomPages() {
		propPage = new PodDrivePropertyWizardPage("propPage");
		addPage(propPage);
	}

	public Properties getProfileProperties() {
		Properties props = new Properties();
		props.setProperty(PodProfilePropertyConstants.POD_FILE_PATH, propPage.getProperty());
		return props;
	}
}
