/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package com.ibm.example.familytree.provider;


import com.ibm.example.familytree.Family;
import com.ibm.example.familytree.FamilytreePackage;
import com.ibm.example.familytree.Individual;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/**
 * This is the item provider adpater for a {@link com.ibm.example.familytree.Individual} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class IndividualItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		ITableItemLabelProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IndividualItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addNamePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_Individual_name_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Individual_name_feature", "_UI_Individual_type"),
				 FamilytreePackage.eINSTANCE.getIndividual_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns Individual.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return getResourceLocator().getImage("full/obj16/Individual");
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getText(Object object) {
		Individual individual = (Individual)object;
		if( individual.getName() == null )
			return "Unnamed individual";
		return individual.getName();
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(Individual.class)) {
			case FamilytreePackage.INDIVIDUAL__NAME: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return FamilyEditPlugin.INSTANCE;
	}

	/**
	 * Return column text.
	 * @param o the row object
	 * @param index the column index
	 * @return column text
	 **/
	public String getColumnText(Object o, int index ){
		if( index == 0 ){
			return getText(o);
		}
		else{
			Object f = getParent(o);
			if( f instanceof Family ){
				if( index == 1 && ((Family)f).getFather() != null ){
					// father
					return getText(((Family)f).getFather());		
				}
				else if( index == 2 && ((Family)f).getMother() != null ){
					// mother
					return getText(((Family)f).getMother());		
				}
			}
		}
		return "unknown";
	}
	
	/**
	 * Return column image.
	 * @param o the row object
	 * @param index the column index
	 * @return column image
	 **/
	public Object getColumnImage(Object o, int index ){
		if( index == 0 ){
			return getImage(o);
		}
		else{
			Object f = getParent(o);
			if( f instanceof Family ){
				if( index == 1 ){
					// father
					return getImage(((Family)f).getFather());		
				}
				else if( index == 2 ){
					// mother
					return getImage(((Family)f).getMother());		
				}
			}
		}
		return null;
	}
	

}
